<?php
/* --------------------------------------------------------------
   WithdrawalCriteria.php 2020-02-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\SqlCriteria;

use DateTime;
use Doctrine\DBAL\Query\QueryBuilder;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalSqlCriteria as WithdrawalSqlCriteriaInterface;
use Gambio\Core\Criteria\AbstractSqlCriteria;

/**
 * Class WithdrawalRestApiCriteria
 *
 * @package Gambio\Admin\Withdrawal\SqlCriteria
 */
class WithdrawalSqlCriteria extends AbstractSqlCriteria implements WithdrawalSqlCriteriaInterface
{
    /**
     * @var DateTime|null
     */
    private $createdAfter;
    
    
    /**
     * WithdrawalSqlCriteria constructor.
     *
     * @param WithdrawalFilters  $filters
     * @param WithdrawalSortings $sortings
     * @param DateTime|null      $createdAfter
     */
    private function __construct(WithdrawalFilters $filters, WithdrawalSortings $sortings, ?DateTime $createdAfter)
    {
        $this->filters      = $filters;
        $this->sortings     = $sortings;
        $this->createdAfter = $createdAfter;
    }
    
    
    /**
     * @param WithdrawalFilters|null  $filters
     * @param WithdrawalSortings|null $sortings
     * @param DateTime|null           $createdAfter
     *
     * @return WithdrawalSqlCriteria
     */
    public static function create(
        WithdrawalFilters $filters,
        WithdrawalSortings $sortings,
        ?DateTime $createdAfter = null
    ): WithdrawalSqlCriteria {
        return new self($filters, $sortings, $createdAfter);
    }
    
    
    /**
     * @param QueryBuilder $query
     */
    public function applyToQuery(QueryBuilder $query): void
    {
        parent::applyToQuery($query);
        
        if ($this->createdAfter !== null) {
            $query->andWhere('date_created >= :criteria_created_after')
                ->setParameter(':criteria_created_after', $this->createdAfter->format('Y-m-d H:i:s'));
        }
    }
}